#ifndef __IO__
#define __IO__

/**
 * @file IO.h
 * @brief Single include for the IO package
 *
 * @date 02/10/2004
 * @author Paul Chana
 * @version 1.0.0 Initial version
 *
 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.\n
 * Certain sections of this code may come from other sources. They are credited where applicable.\n
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 *
 * $Id: IO.h,v 1.6 2007/02/08 21:06:44 paul Exp $
 */

/**
 * @namespace Exponent::IO
 * @brief Input / Output namespace
 *
 * All input and output routines are contained within this namespace, including Text i/o, Binary i/o etc
 */

//#include "CFileIO.hpp"
#include "CFileStream.hpp"
#include "CPresetIO.hpp"
#include "CTextIO.hpp"
#include "CTextStream.hpp"
#include "CXMLAttribute.hpp"
#include "CXMLDocument.hpp"
#include "CXMLNode.hpp"
//#include "IPresetHandler.hpp"

//	===========================================================================

#ifndef EXPONENT_COMPACT_BUILD
	using namespace Exponent::IO;
#endif

#endif	// end of IO.h